/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.opensplice.listener;

import DDS.DataReader;
import DDS.DataReaderListener;
import DDS.LivelinessChangedStatus;
import DDS.RequestedDeadlineMissedStatus;
import DDS.RequestedIncompatibleQosStatus;
import DDS.SampleInfoSeqHolder;
import DDS.SampleLostStatus;
import DDS.SampleRejectedStatus;
import DDS.SubscriptionMatchedStatus;
import java.lang.reflect.InvocationTargetException;
import lac.cnet.sddl.objects.Utils;
import lac.cnet.sddl.udi.core.listener.BaseDataReaderListener;
import lac.cnet.sddl.udi.core.listener.TopicSampleRunner;
import lac.cnet.sddl.udi.core.listener.UDIDataReaderListener;

public class OpenSpliceDataReaderListener<T>
extends BaseDataReaderListener<T>
implements DataReaderListener {
    public OpenSpliceDataReaderListener(UDIDataReaderListener<T> applicationDataReaderListener) {
        super(applicationDataReaderListener);
    }

    public OpenSpliceDataReaderListener(UDIDataReaderListener<T> applicationDataReaderListener, boolean useWrapper) {
        super(applicationDataReaderListener, useWrapper);
    }

    protected void initializeComputationalReflectionVariables(DataReader dataReader) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String topicClassName = this.getTopicTypeName(dataReader);
        Class<?> topicSeqClass = Class.forName(String.valueOf(topicClassName) + "SeqHolder");
        this.topicSeqClassConstructor = topicSeqClass.getConstructor(new Class[0]);
        Object samples = this.topicSeqClassConstructor.newInstance(new Object[0]);
        this.takeMethodParameterTypes = new Class[]{samples.getClass(), SampleInfoSeqHolder.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        this.returnLoanMethodParameterTypes = new Class[]{samples.getClass(), SampleInfoSeqHolder.class};
        this.takeDataReaderMethod = dataReader.getClass().getMethod("take", this.takeMethodParameterTypes);
        this.returnLoanDataReaderMethod = dataReader.getClass().getMethod("return_loan", this.returnLoanMethodParameterTypes);
    }

    protected String getTopicTypeName(DataReader dataReader) {
        String topicClassName = dataReader.getClass().getCanonicalName();
        int replacePosition = dataReader.getClass().getCanonicalName().length() - 14;
        topicClassName = topicClassName.substring(0, replacePosition);
        return topicClassName;
    }

    @Override
    public void on_data_available(DataReader dataReader) {
        Object[] topicSeqSamplesAndInfo = this.getTopicSeqSamplesAndInfo(dataReader);
        if (topicSeqSamplesAndInfo == null) {
            return;
        }
        Object topicSeq = topicSeqSamplesAndInfo[0];
        Object[] sampleArray = (Object[])topicSeqSamplesAndInfo[1];
        if (sampleArray != null) {
            SampleInfoSeqHolder sampleInfo = (SampleInfoSeqHolder)topicSeqSamplesAndInfo[2];
            int i = 0;
            while (i < sampleArray.length) {
                if (sampleInfo.value[i].valid_data) {
                    Object topicSample = this.useWrapper ? Utils.getApplicationObject(sampleArray[i]) : sampleArray[i];
                    this.threadPool.execute(new TopicSampleRunner<Object>(topicSample, this.applicationDataReaderListener));
                }
                ++i;
            }
            this.returnLoan(dataReader, topicSeq, sampleInfo);
        }
    }

    protected void returnLoan(DataReader dataReader, Object samples, SampleInfoSeqHolder sampleInfo) {
        try {
            this.returnLoanDataReaderMethod.invoke((Object)dataReader, samples, sampleInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Object copyTopicSample(Object topicSample) {
        Object topicInstance = topicSample;
        return topicInstance;
    }

    protected Object[] getTopicSeqSamplesAndInfo(DataReader dataReader) {
        Object topicSeq = null;
        try {
            if (this.topicSeqClassConstructor == null) {
                this.initializeComputationalReflectionVariables(dataReader);
            }
            topicSeq = this.topicSeqClassConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        SampleInfoSeqHolder sampleInfo = new SampleInfoSeqHolder();
        Integer returnCode = null;
        Object returnCodeObject = null;
        try {
            returnCodeObject = this.takeDataReaderMethod.invoke((Object)dataReader, topicSeq, sampleInfo, Integer.MAX_VALUE, 2, 65535, 65535);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        returnCode = (Integer)returnCodeObject;
        Object[] result = null;
        if (returnCode == 0) {
            result = new Object[3];
            try {
                result[1] = topicSeq.getClass().getField("value").get(topicSeq);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            result[0] = topicSeq;
            result[2] = sampleInfo;
            return result;
        }
        return null;
    }

    @Override
    public void on_liveliness_changed(DataReader arg0, LivelinessChangedStatus arg1) {
    }

    @Override
    public void on_requested_deadline_missed(DataReader arg0, RequestedDeadlineMissedStatus arg1) {
    }

    @Override
    public void on_requested_incompatible_qos(DataReader arg0, RequestedIncompatibleQosStatus arg1) {
    }

    @Override
    public void on_sample_lost(DataReader arg0, SampleLostStatus arg1) {
    }

    @Override
    public void on_sample_rejected(DataReader arg0, SampleRejectedStatus arg1) {
    }

    @Override
    public void on_subscription_matched(DataReader arg0, SubscriptionMatchedStatus arg1) {
    }
}

