/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.rti;

import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.domain.DomainParticipantFactory;
import com.rti.dds.domain.DomainParticipantQos;
import com.rti.dds.infrastructure.HistoryQosPolicyKind;
import com.rti.dds.infrastructure.ReliabilityQosPolicyKind;
import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.publication.DataWriter;
import com.rti.dds.publication.DataWriterListener;
import com.rti.dds.publication.DataWriterQos;
import com.rti.dds.publication.Publisher;
import com.rti.dds.publication.PublisherListener;
import com.rti.dds.publication.PublisherQos;
import com.rti.dds.subscription.DataReader;
import com.rti.dds.subscription.DataReaderListener;
import com.rti.dds.subscription.DataReaderQos;
import com.rti.dds.subscription.Subscriber;
import com.rti.dds.subscription.SubscriberListener;
import com.rti.dds.subscription.SubscriberQos;
import com.rti.dds.topic.ContentFilteredTopic;
import com.rti.dds.topic.Topic;
import com.rti.dds.topic.TopicDescription;
import com.rti.dds.topic.TypeSupportImpl;
import java.util.List;
import java.util.Map;
import lac.cnet.sddl.udi.core.DDSStandardAPI;
import lac.cnet.sddl.udi.rti.RTIWriterField;
import lac.contextnet.highlyscalablemap.ReadWriteLockMap;

public class RTIAbstractionComponent
implements DDSStandardAPI<Topic, Class<? extends TypeSupportImpl>, ContentFilteredTopic, DomainParticipantQos, SubscriberQos, DomainParticipant, Subscriber, Publisher, PublisherQos, SubscriberListener, PublisherListener, DataReaderListener, DataWriterListener, DataReaderQos, DataWriterQos, DataWriter, DataReader, TopicDescription> {
    protected DomainParticipantFactory domainParticipantFactory;
    protected DomainParticipant domainParticipant;
    protected Subscriber subscriber;
    protected Publisher publisher;
    protected Map<String, DataReader> dataReaderCollection;
    protected Map<String, RTIWriterField> dataWriterCollection;

    @Override
    public DomainParticipant createParticipant(long domainID) {
        return this.createParticipant(domainID, null, null);
    }

    @Override
    public DomainParticipant createParticipant(String domainID) {
        return this.createParticipant(domainID, null, null);
    }

    @Override
    public DomainParticipant createParticipant(long domainID, DomainParticipantQos qos) {
        return this.createParticipant(domainID, qos, (String)null);
    }

    @Override
    public DomainParticipant createParticipant(String domainID, DomainParticipantQos qos) {
        return this.createParticipant(domainID, qos, (String)null);
    }

    @Override
    public DomainParticipant createParticipant(long domainID, DomainParticipantQos qos, String license) {
        if (qos == null) {
            qos = DomainParticipantFactory.PARTICIPANT_QOS_DEFAULT;
            qos.transport_builtin.mask = 1;
        }
        this.domainParticipantFactory = DomainParticipantFactory.get_instance();
        this.domainParticipant = this.domainParticipantFactory.create_participant((int)domainID, qos, null, 0);
        return this.domainParticipant;
    }

    @Override
    public DomainParticipant createParticipant(String domainID, DomainParticipantQos qos, String license) {
        return this.createParticipant((long)domainID.hashCode(), qos, license);
    }

    @Override
    public ContentFilteredTopic createContentFilteredTopic(String topicName, Topic topic, String logicalExpression, List<String> parameters) {
        StringSeq parameterStringSeq = null;
        parameterStringSeq = parameters != null ? new StringSeq(parameters) : new StringSeq();
        return this.domainParticipant.create_contentfilteredtopic(topicName, topic, logicalExpression, parameterStringSeq);
    }

    @Override
    public Subscriber createSubscriber(SubscriberQos sub_qos, SubscriberListener sub_listener) {
        this.subscriber = this.domainParticipant.create_subscriber(DomainParticipant.SUBSCRIBER_QOS_DEFAULT, sub_listener, 0);
        this.dataReaderCollection = new ReadWriteLockMap<String, DataReader>(false, false);
        return this.subscriber;
    }

    @Override
    public Publisher createPublisher(PublisherQos pub_qos, PublisherListener pub_listener) {
        this.publisher = this.domainParticipant.create_publisher(DomainParticipant.PUBLISHER_QOS_DEFAULT, pub_listener, 0);
        this.dataWriterCollection = new ReadWriteLockMap<String, RTIWriterField>(false, false);
        return this.publisher;
    }

    @Override
    public DataReaderQos getDefaultDataReaderQoS() {
        DataReaderQos dataReaderQoS = new DataReaderQos();
        this.subscriber.get_default_datareader_qos(dataReaderQoS);
        dataReaderQoS.reliability.kind = ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
        dataReaderQoS.history.kind = HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS;
        return dataReaderQoS;
    }

    @Override
    public DataWriterQos getDefaultDataWriterQoS() {
        DataWriterQos dataWriterQoS = new DataWriterQos();
        this.publisher.get_default_datawriter_qos(dataWriterQoS);
        dataWriterQoS.reliability.kind = ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
        dataWriterQoS.history.kind = HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS;
        dataWriterQoS.batch.enable = true;
        dataWriterQoS.batch.max_flush_delay.nanosec = 0;
        dataWriterQoS.batch.max_flush_delay.sec = -1;
        return dataWriterQoS;
    }

    @Override
    public Topic createTopic(String typeName, String topicName) {
        try {
            Class<?> typeSupportClass = Class.forName(String.valueOf(typeName) + "TypeSupport");
            return this.createTopic(typeSupportClass, topicName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Topic createTopic(Class<? extends TypeSupportImpl> topicTypeSupport, String topicName) {
        String typeName = null;
        try {
            typeName = (String)topicTypeSupport.getMethod("get_type_name", new Class[0]).invoke(null, new Object[0]);
            Class[] register_TypeMethodParameterTypes = new Class[]{DomainParticipant.class, String.class};
            topicTypeSupport.getMethod("register_type", register_TypeMethodParameterTypes).invoke(null, this.domainParticipant, typeName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TopicDescription topicDescription = this.domainParticipant.lookup_topicdescription(topicName);
        if (topicDescription != null) {
            return (Topic)topicDescription;
        }
        Topic topic = this.domainParticipant.create_topic(topicName, typeName, DomainParticipant.TOPIC_QOS_DEFAULT, null, 0);
        return topic;
    }

    @Override
    public DataReader createDataReader(TopicDescription topicDescription, DataReaderQos dataReaderQoS, DataReaderListener dataReaderListener) {
        String dataReaderName = this.getCompleteTopicName(topicDescription);
        DataReader dataReader = this.dataReaderCollection.get(dataReaderName);
        if (dataReader == null) {
            if (dataReaderQoS == null) {
                dataReaderQoS = this.getDefaultDataReaderQoS();
            }
            dataReader = this.subscriber.create_datareader(topicDescription, dataReaderQoS, dataReaderListener, 1024);
            this.dataReaderCollection.put(dataReaderName, dataReader);
        }
        return dataReader;
    }

    @Override
    public DataWriter createDataWriter(Topic topic, DataWriterQos dataWriterQoS, DataWriterListener dataWriterListener) {
        String dataWriterName = this.getCompleteTopicName(topic);
        RTIWriterField rTIWriterField = this.dataWriterCollection.get(dataWriterName);
        if (rTIWriterField == null) {
            if (dataWriterQoS == null) {
                dataWriterQoS = this.getDefaultDataWriterQoS();
            }
            DataWriter dataWriter = this.publisher.create_datawriter(topic, dataWriterQoS, dataWriterListener, 0);
            rTIWriterField = new RTIWriterField(dataWriter);
            this.dataWriterCollection.put(dataWriterName, rTIWriterField);
        }
        return rTIWriterField.getDataWriter();
    }

    @Override
    public boolean writeTopic(String topicName, Object topic) {
        RTIWriterField rTIWriterField = this.dataWriterCollection.get(this.getCompleteTopicName(topicName, topic));
        if (rTIWriterField != null) {
            return rTIWriterField.writeTopic(topic);
        }
        return false;
    }

    @Override
    public boolean deleteParticipant() {
        this.domainParticipant.delete_contained_entities();
        this.domainParticipantFactory.delete_participant(this.domainParticipant);
        return true;
    }

    @Override
    public boolean deletePublisher() {
        this.domainParticipant.delete_publisher(this.publisher);
        return true;
    }

    @Override
    public boolean deleteSubscriber() {
        this.domainParticipant.delete_subscriber(this.subscriber);
        return true;
    }

    @Override
    public boolean deleteDataReader(String dataReaderName) {
        DataReader dataReader = this.dataReaderCollection.get(dataReaderName);
        if (dataReader != null) {
            dataReader.delete_contained_entities();
            this.subscriber.delete_datareader(dataReader);
            this.dataReaderCollection.remove(dataReaderName);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteDataWriter(String dataWriterName) {
        DataWriter dataWriter = this.dataWriterCollection.get(dataWriterName).getDataWriter();
        if (dataWriter != null) {
            this.publisher.delete_datawriter(dataWriter);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteTopic(Topic topic) {
        this.domainParticipant.delete_topic(topic);
        return true;
    }

    @Override
    public boolean close() {
        this.domainParticipant.delete_contained_entities();
        this.domainParticipantFactory.delete_participant(this.domainParticipant);
        return true;
    }

    public String getCompleteTopicName(TopicDescription topic) {
        return String.valueOf(topic.get_type_name()) + topic.get_name();
    }

    public String getCompleteTopicName(String topicName, Object topic) {
        return String.valueOf(topic.getClass().getSimpleName()) + topicName;
    }

    public DataReader getDataReader(String dataReaderCompleteName) {
        return this.dataReaderCollection.get(dataReaderCompleteName);
    }

    public DataWriter getDataWriter(String dataReaderCompleteName) {
        return this.dataWriterCollection.get(dataReaderCompleteName).getDataWriter();
    }
}

