/*
 * Decompiled with CFR 0.152.
 */
package lac.contextnet.highlyscalablelist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteLockList<V>
implements List<V> {
    private final ReentrantReadWriteLock lock;
    private final List<V> list;

    public ReadWriteLockList() {
        this.lock = new ReentrantReadWriteLock();
        this.list = new LinkedList<V>();
    }

    public ReadWriteLockList(boolean linkedList, boolean fairReadWriteLock, int initialArrayListSize) {
        this.lock = new ReentrantReadWriteLock(fairReadWriteLock);
        this.list = linkedList ? new LinkedList<V>() : new ArrayList<V>(initialArrayListSize);
    }

    @Override
    public boolean add(V element) {
        this.lock.writeLock().lock();
        boolean result = this.list.add(element);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public void add(int index, V element) {
        this.lock.writeLock().lock();
        this.list.add(index, element);
        this.lock.writeLock().unlock();
    }

    @Override
    public boolean addAll(Collection<? extends V> collection) {
        this.lock.writeLock().lock();
        boolean result = this.list.addAll(collection);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> collection) {
        this.lock.writeLock().lock();
        boolean result = this.list.addAll(index, collection);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        this.list.clear();
        this.lock.writeLock().unlock();
    }

    @Override
    public boolean contains(Object object) {
        this.lock.readLock().lock();
        boolean result = this.list.contains(object);
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.lock.readLock().lock();
        boolean result = this.list.containsAll(collection);
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public V get(int index) {
        V result = null;
        this.lock.readLock().lock();
        result = this.list.get(index);
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public int indexOf(Object object) {
        this.lock.readLock().lock();
        int result = this.list.indexOf(object);
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        boolean result = this.list.isEmpty();
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public Iterator<V> iterator() {
        List<V> objects = null;
        this.lock.readLock().lock();
        objects = this.list.subList(0, this.size());
        this.lock.readLock().unlock();
        return objects.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        this.lock.readLock().lock();
        int result = this.list.lastIndexOf(object);
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public ListIterator<V> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        List<V> objects = null;
        this.lock.readLock().lock();
        objects = this.list.subList(0, this.size());
        this.lock.readLock().unlock();
        return objects.listIterator(index);
    }

    @Override
    public boolean remove(Object object) {
        this.lock.writeLock().lock();
        boolean result = this.list.remove(object);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public V remove(int index) {
        V result = null;
        this.lock.writeLock().lock();
        result = this.list.remove(index);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = false;
        this.lock.writeLock().lock();
        Iterator<V> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            result = true;
        }
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.lock.writeLock().lock();
        boolean result = this.list.retainAll(collection);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public V set(int index, V element) {
        V result = null;
        this.lock.writeLock().lock();
        result = this.list.set(index, element);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<V> subList(int fromIndex, int toIndex) {
        List<V> objects = null;
        this.lock.readLock().lock();
        objects = this.list.subList(fromIndex, toIndex);
        this.lock.readLock().unlock();
        return objects;
    }

    @Override
    public Object[] toArray() {
        Object[] array = null;
        this.lock.readLock().lock();
        array = this.list.toArray();
        this.lock.readLock().unlock();
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] array = null;
        this.lock.readLock().lock();
        array = this.list.toArray(a);
        this.lock.readLock().unlock();
        return array;
    }
}

