/*
 * Decompiled with CFR 0.152.
 */
package lac.contextnet.highlyscalablemap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lac.contextnet.highlyscalablemap.ReadWriteLockMap;
import lac.contextnet.highlyscalablestructure.interfaces.HighlyScalableIndex;

public class HighlyScalableMap<K, V>
implements Map<K, V> {
    private static final int defaultLockGrainSize = Runtime.getRuntime().availableProcessors() * 2;
    private ArrayList<ReadWriteLockMap<K, V>> readWriteLockMaps;
    private int lockGrainSize;

    public HighlyScalableMap() {
        this.initializeHighScalableMap(true, false, 0, defaultLockGrainSize);
    }

    public HighlyScalableMap(int lockGrainSize) {
        this.initializeHighScalableMap(true, false, 0, lockGrainSize);
    }

    public HighlyScalableMap(boolean treeMap, boolean fairReadWriteLock, int initialHashCapacity, int lockGrainSize) {
        this.initializeHighScalableMap(treeMap, fairReadWriteLock, initialHashCapacity, lockGrainSize);
    }

    private void initializeHighScalableMap(boolean treeMap, boolean fairReadWriteLock, int initialHashCapacity, int lockGrainSize) {
        this.lockGrainSize = lockGrainSize;
        this.readWriteLockMaps = new ArrayList(this.lockGrainSize);
        int i = 0;
        while (i < this.lockGrainSize) {
            if (treeMap) {
                this.readWriteLockMaps.add(new ReadWriteLockMap(treeMap, fairReadWriteLock));
            } else {
                this.readWriteLockMaps.add(new ReadWriteLockMap(fairReadWriteLock, initialHashCapacity));
            }
            ++i;
        }
    }

    private int getMapPosition(Object key) {
        if (key instanceof HighlyScalableIndex) {
            HighlyScalableIndex highScalableKey = (HighlyScalableIndex)key;
            return Math.abs((int)(highScalableKey.getHighScalableIndex() % (long)this.lockGrainSize));
        }
        return Math.abs(key.hashCode() % this.lockGrainSize);
    }

    @Override
    public void clear() {
        for (ReadWriteLockMap<K, V> map : this.readWriteLockMaps) {
            map.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        int mapPosition = this.getMapPosition(key);
        boolean result = this.readWriteLockMaps.get(mapPosition).containsKey(key);
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean result = false;
        int i = 0;
        while (i < this.readWriteLockMaps.size()) {
            ReadWriteLockMap<K, V> map = this.readWriteLockMaps.get(i);
            if (map.containsValue(value)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>(this.size() + 100, 1.0f);
        int i = 0;
        while (i < this.readWriteLockMaps.size()) {
            ReadWriteLockMap<K, V> map = this.readWriteLockMaps.get(i);
            for (Map.Entry<K, V> entry : map.entrySet()) {
                result.add(entry);
            }
            ++i;
        }
        return result;
    }

    @Override
    public V get(Object key) {
        V result = null;
        int mapPosition = this.getMapPosition(key);
        result = this.readWriteLockMaps.get(mapPosition).get(key);
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = true;
        for (ReadWriteLockMap<K, V> map : this.readWriteLockMaps) {
            if (map.isEmpty()) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> result = new HashSet<K>(this.size() + 100, 1.0f);
        for (ReadWriteLockMap<K, V> map : this.readWriteLockMaps) {
            for (K key : map.keySet()) {
                result.add(key);
            }
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        V result = null;
        int mapPosition = this.getMapPosition(key);
        result = this.readWriteLockMaps.get(mapPosition).put(key, value);
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Set<K> keySet = m.keySet();
        for (K highScalableKey : keySet) {
            this.put(highScalableKey, m.get(highScalableKey));
        }
    }

    @Override
    public V remove(Object key) {
        V result = null;
        int mapPosition = this.getMapPosition(key);
        result = this.readWriteLockMaps.get(mapPosition).remove(key);
        return result;
    }

    @Override
    public int size() {
        long size = 0L;
        for (ReadWriteLockMap<K, V> map : this.readWriteLockMaps) {
            if ((size += (long)map.size()) < Integer.MAX_VALUE) continue;
            size = Integer.MAX_VALUE;
            break;
        }
        return (int)size;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>(this.size() + 100);
        for (ReadWriteLockMap<K, V> map : this.readWriteLockMaps) {
            values.addAll(map.values());
        }
        return values;
    }
}

