/*
 * Decompiled with CFR 0.152.
 */
package lac.contextnet.highlyscalablemap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteLockMap<K, V>
implements Map<K, V> {
    private final ReentrantReadWriteLock lock;
    private final Map<K, V> map;

    public ReadWriteLockMap() {
        this.map = new TreeMap();
        this.lock = new ReentrantReadWriteLock();
    }

    public ReadWriteLockMap(boolean treeMap, boolean fairReadWriteLock) {
        this.map = treeMap ? new TreeMap() : new HashMap();
        this.lock = new ReentrantReadWriteLock(fairReadWriteLock);
    }

    public ReadWriteLockMap(boolean fairReadWriteLock, int initialHashCapacity) {
        this.map = new HashMap(initialHashCapacity);
        this.lock = new ReentrantReadWriteLock(fairReadWriteLock);
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        this.map.clear();
        this.lock.writeLock().unlock();
    }

    @Override
    public boolean containsKey(Object key) {
        this.lock.readLock().lock();
        boolean result = this.map.containsKey(key);
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        this.lock.readLock().lock();
        boolean result = this.map.containsValue(value);
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet result = null;
        this.lock.writeLock().lock();
        result = this.map instanceof TreeMap ? new LinkedHashSet(this.map.size(), 1.0f) : new HashSet(this.map.size(), 1.0f);
        for (Map.Entry<K, V> object : this.map.entrySet()) {
            result.add(object);
        }
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public V get(Object key) {
        V result = null;
        this.lock.readLock().lock();
        result = this.map.get(key);
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        boolean result = this.map.isEmpty();
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public Set<K> keySet() {
        HashSet result = null;
        this.lock.readLock().lock();
        result = this.map instanceof TreeMap ? new LinkedHashSet(this.map.size(), 1.0f) : new HashSet(this.map.size(), 1.0f);
        for (K object : this.map.keySet()) {
            result.add(object);
        }
        this.lock.readLock().unlock();
        return result;
    }

    @Override
    public V put(K key, V value) {
        this.lock.writeLock().lock();
        V result = this.map.put(key, value);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.lock.writeLock().lock();
        this.map.putAll(m);
        this.lock.writeLock().unlock();
    }

    @Override
    public V remove(Object key) {
        V result = null;
        this.lock.writeLock().lock();
        result = this.map.remove(key);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = null;
        this.lock.readLock().lock();
        result = new ArrayList<V>(this.map.values());
        this.lock.readLock().unlock();
        return result;
    }
}

