/*
 * Decompiled with CFR 0.152.
 */
package manager;

import data.AdaptationResponseWrapper;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.objects.GroupReport;
import lac.cnet.sddl.objects.PrivateMessage;
import lac.cnet.sddl.udi.core.SddlLayer;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import lac.cnet.sddl.udi.core.listener.UDIDataReaderListener;
import manager.GlobalAdaptionService;
import manager.TopicMapper;

public class AdaptionManager
implements UDIDataReaderListener<ApplicationObject> {
    public final GlobalAdaptionService globalAdaptionService;
    protected final SddlLayer dds;

    public AdaptionManager() {
        TopicMapper topicMapper = new TopicMapper();
        UniversalDDSLayerFactory.addCustomTopicMapper(topicMapper);
        this.dds = UniversalDDSLayerFactory.getInstance();
        this.dds.createParticipant(0L);
        this.dds.createPublisher();
        this.dds.createSubscriber();
        Object privateMessagetopic = this.dds.createTopic(PrivateMessage.class, PrivateMessage.class.getSimpleName());
        this.dds.createDataWriter(privateMessagetopic);
        Object adaptationResponseTopic = this.dds.createTopic(AdaptationResponseWrapper.class, AdaptationResponseWrapper.class.getSimpleName());
        this.dds.createDataReader(this, adaptationResponseTopic);
        Object groupReportTopic = this.dds.createTopic(GroupReport.class, GroupReport.class.getSimpleName());
        this.dds.createDataReader(this, groupReportTopic);
        this.globalAdaptionService = new GlobalAdaptionService(this.dds);
    }

    @Override
    public void onNewData(ApplicationObject topicSample) {
        if (topicSample instanceof AdaptationResponseWrapper) {
            this.globalAdaptionService.receiveResponse((AdaptationResponseWrapper)topicSample);
        } else if (topicSample instanceof GroupReport) {
            this.globalAdaptionService.receiveGroupReport((GroupReport)topicSample);
        }
    }
}

