/*
 * Decompiled with CFR 0.152.
 */
package manager;

import data.ActionList;
import data.AdaptationCommand;
import data.AdaptationPlan;
import data.AdaptationResponseWrapper;
import data.CommandCode;
import data.CommandMessage;
import data.LoadJarMessage;
import data.MessageCode;
import data.Transaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.serialization.Serialization;
import lac.cnet.sddl.objects.GroupReport;
import lac.cnet.sddl.objects.PrivateMessage;
import lac.cnet.sddl.udi.core.SddlLayer;
import manager.ResponseController;
import utils.Utils;

public class GlobalAdaptionService {
    protected final SddlLayer dds;
    protected final ResponseController responseController;
    protected static final Logger LOGGER = Logger.getLogger(GlobalAdaptionService.class.getName());
    public static final String ADAPTATION_TAG = "@";
    private long initialTime;

    public GlobalAdaptionService(SddlLayer dds) {
        this.dds = dds;
        this.responseController = new ResponseController();
        LOGGER.setLevel(Level.FINE);
    }

    public void receiveResponse(AdaptationResponseWrapper adaptationResponseTopic) {
        long finalTime = System.nanoTime();
        String message = (String)((Object)Serialization.fromJavaByteStream(adaptationResponseTopic.getMessage()));
        LOGGER.log(Level.FINEST, message);
        Transaction transaction = this.responseController.addNewResponse(adaptationResponseTopic.getAdaptationId());
        if (transaction == null) {
            LOGGER.warning("Transaction NULL!" + adaptationResponseTopic.getAdaptationId() + " " + adaptationResponseTopic.getNodeId());
            return;
        }
        if (transaction.aborted) {
            return;
        }
        if (adaptationResponseTopic.getMessageCode() == MessageCode.AdaptionFailure) {
            LOGGER.info("ERROR on a MN: " + message + " " + adaptationResponseTopic.getAdaptationId() + " " + adaptationResponseTopic.getNodeId());
            this.handleAdaptationFailure(transaction);
            return;
        }
        if (transaction.pendingResponses == 0) {
            if (transaction.adaptationPlan.transactionalAdaptation && transaction.adaptationPlan.adaptationCommandList.size() > 0) {
                this.sendAdaptationPlan(transaction.adaptationPlan, false);
            } else {
                LOGGER.info("Tempo da adapta\ufffd\ufffdo: " + (double)(finalTime - this.initialTime) / 1000000.0);
            }
        }
    }

    protected void handleAdaptationFailure(Transaction transaction) {
        if (transaction.adaptationPlan.transactionalAdaptation) {
            transaction.aborted = true;
            ArrayList<AdaptationCommand> adaptationCommandList = new ArrayList<AdaptationCommand>(transaction.adaptationPlan.executedAdaptationCommandList.size() + 1);
            adaptationCommandList.addAll(transaction.adaptationPlan.executedAdaptationCommandList);
            if (transaction.pendingResponses > 0) {
                adaptationCommandList.add(transaction.adaptationPlan.adaptationCommandList.get(0));
            }
            if (adaptationCommandList.size() == 0) {
                System.out.println("adaptationCommandList.size == 0. N\ufffdo deveria acontecer isto");
                System.out.println(transaction.toString());
            }
            AdaptationPlan rollbackActionPlan = this.generateRollbackAdaptationPlan(transaction, adaptationCommandList);
            this.sendAdaptationPlan(rollbackActionPlan, false);
        }
    }

    protected AdaptationPlan generateRollbackAdaptationPlan(Transaction transaction, List<AdaptationCommand> adaptationCommandList) {
        AdaptationPlan adaptationPlan = new AdaptationPlan();
        adaptationPlan.setNodeList(transaction.adaptationPlan.nodeList);
        adaptationPlan.transactionalAdaptation = true;
        int i = adaptationCommandList.size() - 1;
        while (i >= 0) {
            try {
                AdaptationCommand rollbackAdaptationCommand = this.generateRollbackAdaptationCommand(adaptationCommandList.get(i));
                if (rollbackAdaptationCommand != null && rollbackAdaptationCommand.commandMessage != null) {
                    adaptationPlan.adaptationCommandList.add(rollbackAdaptationCommand);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            --i;
        }
        return adaptationPlan;
    }

    protected AdaptationCommand generateRollbackAdaptationCommand(AdaptationCommand adaptationCommand) throws Exception {
        AdaptationCommand rollbackAdaptationCommand = new AdaptationCommand(adaptationCommand.adaptationId * -1);
        if (adaptationCommand.commandMessage.commandCode == CommandCode.InsertComponent) {
            rollbackAdaptationCommand.commandMessage = new CommandMessage(adaptationCommand.commandMessage.componentName, adaptationCommand.commandMessage.componentClass, CommandCode.RemoveComponent);
        } else if (adaptationCommand.commandMessage.commandCode == CommandCode.UpdateComponentInstances) {
            rollbackAdaptationCommand.commandMessage = adaptationCommand.commandMessage.copy(CommandCode.RollbackUpdateComponentInstances);
        } else if (adaptationCommand.commandMessage.commandCode == CommandCode.EnableComponent) {
            rollbackAdaptationCommand.commandMessage = new CommandMessage(adaptationCommand.commandMessage.componentName, adaptationCommand.commandMessage.componentClass, CommandCode.DisableComponent);
        } else if (adaptationCommand.commandMessage.commandCode == CommandCode.RemoveComponent) {
            rollbackAdaptationCommand.commandMessage = adaptationCommand.commandMessage.copy(CommandCode.InsertComponent);
        } else if (adaptationCommand.commandMessage.commandCode == CommandCode.DisableComponent) {
            rollbackAdaptationCommand.commandMessage = new CommandMessage(adaptationCommand.commandMessage.componentName, adaptationCommand.commandMessage.componentClass, CommandCode.EnableComponent);
        }
        return rollbackAdaptationCommand;
    }

    public void receiveGroupReport(GroupReport groupReport) {
        this.responseController.addNodesToTransaction(groupReport.getMessageId(), groupReport.getNumberOfNodes());
    }

    protected boolean sendJarToNodes(String jarPathname, int adaptationId, boolean transactionalAdaptation, PrivateMessage ... nodes) throws IOException {
        ApplicationMessage applicationMessage = new ApplicationMessage();
        ActionList actionPlan = new ActionList(transactionalAdaptation, adaptationId);
        LoadJarMessage adaptationMessage = new LoadJarMessage(Utils.getBytesFromFile(jarPathname), jarPathname);
        actionPlan.adaptationActionList.add(adaptationMessage);
        applicationMessage.setContentObject(actionPlan);
        applicationMessage.setTagList(new LinkedList<String>());
        applicationMessage.addTag(ADAPTATION_TAG);
        this.sendMessageToNodes(applicationMessage, adaptationId, nodes);
        return true;
    }

    private void sendMessageToNodes(ApplicationMessage applicationMessage, int adaptationId, PrivateMessage ... nodes) {
        byte[] byteArray = Serialization.toProtocolMessage(applicationMessage);
        PrivateMessage[] privateMessageArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            PrivateMessage privateMessage = privateMessageArray[n2];
            privateMessage.setMessage(byteArray);
            privateMessage.setMessageId(adaptationId);
            this.dds.writeTopic(PrivateMessage.class.getSimpleName(), privateMessage);
            ++n2;
        }
    }

    public boolean sendAdaptationPlan(AdaptationPlan adaptationPlan) {
        return this.sendAdaptationPlan(adaptationPlan, true);
    }

    protected boolean sendAdaptationPlan(AdaptationPlan adaptationPlan, boolean resetTime) {
        ActionList actionPlan = !adaptationPlan.transactionalAdaptation ? this.generateNonTransactionalActionPlan(adaptationPlan) : this.generateTransactionalActionPlan(adaptationPlan);
        this.responseController.addNewTransaction(actionPlan.adaptationId, adaptationPlan, adaptationPlan.nodeList);
        ApplicationMessage applicationMessage = new ApplicationMessage();
        applicationMessage.setTagList(new LinkedList<String>());
        applicationMessage.addTag(ADAPTATION_TAG);
        applicationMessage.setContentObject(actionPlan);
        this.sendMessageToNodes(applicationMessage, actionPlan.adaptationId, adaptationPlan.nodeList);
        if (resetTime) {
            this.initialTime = System.nanoTime();
        }
        return true;
    }

    protected ActionList generateNonTransactionalActionPlan(AdaptationPlan adaptationPlan) {
        ActionList actionPlan = new ActionList(false, adaptationPlan.adaptationCommandList.get((int)0).adaptationId);
        for (AdaptationCommand adaptationCommand : adaptationPlan.adaptationCommandList) {
            actionPlan.adaptationActionList.add(adaptationCommand.commandMessage);
        }
        return actionPlan;
    }

    protected ActionList generateTransactionalActionPlan(AdaptationPlan adaptationPlan) {
        AdaptationCommand adaptationCommand = adaptationPlan.adaptationCommandList.get(0);
        ActionList actionPlan = new ActionList(true, adaptationCommand.adaptationId);
        actionPlan.adaptationActionList.add(adaptationCommand.commandMessage);
        AdaptationCommand commitUpdateAdaptationCommand = this.checkAndGenerateCommitUpdateComponentCommand(adaptationPlan, adaptationCommand);
        if (commitUpdateAdaptationCommand != null) {
            adaptationPlan.adaptationCommandList.add(1, commitUpdateAdaptationCommand);
        }
        return actionPlan;
    }

    protected AdaptationCommand checkAndGenerateCommitUpdateComponentCommand(AdaptationPlan adaptationPlan, AdaptationCommand adaptationCommand) {
        AdaptationCommand additionalAdaptationCommand = null;
        if (adaptationCommand.commandMessage.commandCode == CommandCode.UpdateComponentInstances) {
            if (adaptationPlan.adaptationCommandList.size() > 1) {
                additionalAdaptationCommand = adaptationPlan.adaptationCommandList.get(1);
                if (additionalAdaptationCommand.commandMessage.commandCode != CommandCode.CommitUpdateComponentInstances) {
                    additionalAdaptationCommand = new AdaptationCommand(adaptationCommand.adaptationId + 100, adaptationCommand.commandMessage.copy(CommandCode.CommitUpdateComponentInstances));
                }
            } else {
                additionalAdaptationCommand = new AdaptationCommand(adaptationCommand.adaptationId * 100, adaptationCommand.commandMessage.copy(CommandCode.CommitUpdateComponentInstances));
            }
        }
        return additionalAdaptationCommand;
    }
}

