/*
 * Decompiled with CFR 0.152.
 */
package manager;

import data.AdaptationPlan;
import data.Transaction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import lac.cnet.sddl.objects.PrivateMessage;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class ResponseController {
    protected final Map<Integer, Transaction> pendingTransactionsIndexedById = new HashMap<Integer, Transaction>();

    public void addNewTransaction(int id, AdaptationPlan adaptationPlan, PrivateMessage ... privateMessages) {
        Transaction transaction = !privateMessages[0].getNodeId().equals(UniversalDDSLayerFactory.BROADCAST_ID) ? new Transaction(id, privateMessages.length, adaptationPlan) : new Transaction(id, 0, adaptationPlan);
        this.pendingTransactionsIndexedById.put(id, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNodesToTransaction(int adaptationId, int numberOfNodes) {
        Transaction pendingTransaction = this.pendingTransactionsIndexedById.get(adaptationId);
        if (pendingTransaction != null) {
            if (pendingTransaction.fisrtPlanTransaction) {
                Transaction transaction = pendingTransaction;
                synchronized (transaction) {
                    pendingTransaction.pendingResponses += numberOfNodes;
                }
            }
        } else {
            Logger.getGlobal().log(Level.WARNING, "ResponseController.addNodesToTransaction -> pendingTransaction NULL! Id " + adaptationId);
        }
        return pendingTransaction.pendingResponses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction addNewResponse(int id) {
        Transaction pendingTransaction = this.pendingTransactionsIndexedById.get(id);
        if (pendingTransaction != null) {
            Transaction transaction = pendingTransaction;
            synchronized (transaction) {
                if (pendingTransaction.addNewResponse()) {
                    this.pendingTransactionsIndexedById.remove(id);
                    pendingTransaction.adaptationPlan.removeAdaptationCommand(0);
                }
            }
        } else {
            Logger.getGlobal().log(Level.WARNING, "ResponseController.addNewResponse -> pendingResponses NULL! Id " + id);
        }
        return pendingTransaction;
    }
}

