/*
 * Decompiled with CFR 0.152.
 */
package net.rudp;

import java.io.IOException;
import java.io.OutputStream;
import net.rudp.ReliableSocket;

public class ReliableSocketOutputStream
extends OutputStream {
    protected ReliableSocket _sock;
    protected byte[] _buf;
    protected int _count;
    protected int _lastSeq;

    public ReliableSocketOutputStream(ReliableSocket sock) throws IOException {
        if (sock == null) {
            throw new NullPointerException("sock");
        }
        this._sock = sock;
        this._buf = new byte[this._sock.getSendBufferSize()];
        this._count = 0;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this._count >= this._buf.length) {
            this.flush();
        }
        this._buf[this._count++] = (byte)(b & 0xFF);
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int writtenBytes = 0;
        while (writtenBytes < len) {
            int buflen = Math.min(this._buf.length, len - writtenBytes);
            if (buflen > this._buf.length - this._count) {
                this.flush();
            }
            System.arraycopy(b, off + writtenBytes, this._buf, this._count, buflen);
            this._count += buflen;
            writtenBytes += buflen;
        }
    }

    public synchronized int flushAndGetSeq() throws IOException {
        if (this._count > 0) {
            this._lastSeq = this._sock.write(this._buf, 0, this._count);
            this._count = 0;
        }
        return this._lastSeq;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushAndGetSeq();
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this._sock.shutdownOutput();
    }
}

