/*
 * Decompiled with CFR 0.152.
 */
package net.rudp.impl;

import net.rudp.impl.Segment;

public class DATSegment
extends Segment {
    private byte[] _data;

    public DATSegment() {
    }

    public DATSegment(int seqn, int ackn, byte[] b, int off, int len) {
        this.init(64, seqn, 6);
        this.setAck(ackn);
        this._data = new byte[len];
        System.arraycopy(b, off, this._data, 0, len);
    }

    @Override
    public int length() {
        return this._data.length + super.length();
    }

    @Override
    public String type() {
        return "DAT";
    }

    public byte[] getData() {
        return this._data;
    }

    @Override
    public byte[] getBytes() {
        byte[] buffer = super.getBytes();
        System.arraycopy(this._data, 0, buffer, 6, this._data.length);
        return buffer;
    }

    @Override
    public void parseBytes(byte[] buffer, int off, int len) {
        super.parseBytes(buffer, off, len);
        this._data = new byte[len - 6];
        System.arraycopy(buffer, off + 6, this._data, 0, this._data.length);
    }

    public byte[] get_data() {
        return this._data;
    }

    public void set_data(byte[] _data) {
        this._data = _data;
    }
}

