/*
 * Decompiled with CFR 0.152.
 */
package net.rudp.impl;

import net.rudp.impl.ACKSegment;

public class EAKSegment
extends ACKSegment {
    private int[] _acks;

    protected EAKSegment() {
    }

    public EAKSegment(int seqn, int ackn, int[] acks) {
        this.init(32, seqn, 6 + acks.length);
        this.setAck(ackn);
        this._acks = acks;
    }

    @Override
    public String type() {
        return "EAK";
    }

    @Override
    public byte[] getBytes() {
        byte[] buffer = super.getBytes();
        int i = 0;
        while (i < this._acks.length) {
            buffer[4 + i] = (byte)(this._acks[i] & 0xFF);
            ++i;
        }
        return buffer;
    }

    @Override
    protected void parseBytes(byte[] buffer, int off, int len) {
        super.parseBytes(buffer, off, len);
        this._acks = new int[len - 6];
        int i = 0;
        while (i < this._acks.length) {
            this._acks[i] = buffer[off + 4 + i] & 0xFF;
            ++i;
        }
    }

    public void set_acks(int[] _acks) {
        this._acks = _acks;
    }

    public int[] getACKs() {
        return this._acks;
    }
}

