/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;
import org.apache.log4j.PropertyConfigurator;
import org.hyperic.sigar.cmd.Version;
import org.hyperic.sigar.test.SigarTestCase;

public class SigarTestPrinter
extends ResultPrinter {
    private HashMap failures = new HashMap();
    private int maxNameLen = 0;
    private static boolean printedVersion;
    private static final String PREFIX = "org.hyperic.sigar.test.";
    private static final String[][] LOG_PROPS;

    public SigarTestPrinter(PrintStream writer) {
        super(writer);
    }

    public void startTest(Test test) {
        PrintStream writer = this.getWriter();
        String cls = test.getClass().getName();
        cls = cls.substring(PREFIX.length());
        String method = ((TestCase)test).getName();
        String name = cls + "." + method;
        writer.print(name);
        int n = this.maxNameLen + 3 - name.length();
        for (int i = 0; i < n; ++i) {
            writer.print('.');
        }
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.failures.put(test, Boolean.TRUE);
        this.getWriter().println("FAILED");
    }

    public void addError(Test test, Throwable t) {
        this.failures.put(test, Boolean.TRUE);
        this.getWriter().println("ERROR");
    }

    public void endTest(Test test) {
        if (this.failures.get(test) != Boolean.TRUE) {
            this.getWriter().println("ok");
        }
    }

    protected void printDefectHeader(TestFailure failure, int count) {
        this.getWriter().println(count + ") " + failure.failedTest().getClass().getName() + ":");
    }

    public void printVersionInfo() {
        if (printedVersion) {
            return;
        }
        printedVersion = true;
        PrintStream writer = this.getWriter();
        Version.printInfo(writer);
        writer.println("");
    }

    public static void addTest(SigarTestPrinter printer, TestSuite suite, Class test) {
        int len = test.getName().length();
        if (len > printer.maxNameLen) {
            printer.maxNameLen = len;
        }
        suite.addTestSuite(test);
    }

    private static Class findTest(Class[] tests, String name) {
        String tname = "Test" + name;
        for (int i = 0; i < tests.length; ++i) {
            if (!tests[i].getName().endsWith(tname)) continue;
            return tests[i];
        }
        return null;
    }

    public static void runTests(Class[] tests, String[] args) {
        TestSuite suite = new TestSuite("Sigar tests");
        SigarTestPrinter printer = new SigarTestPrinter(System.out);
        printer.printVersionInfo();
        if (args.length > 0) {
            int i;
            Properties props = new Properties();
            for (i = 0; i < LOG_PROPS.length; ++i) {
                props.setProperty(LOG_PROPS[i][0], LOG_PROPS[i][1]);
            }
            PropertyConfigurator.configure((Properties)props);
            SigarTestCase.setVerbose(true);
            SigarTestCase.setWriter(printer.getWriter());
            for (i = 0; i < args.length; ++i) {
                Class test = SigarTestPrinter.findTest(tests, args[i]);
                if (test == null) {
                    String msg = "Invalid test: " + args[i];
                    throw new IllegalArgumentException(msg);
                }
                SigarTestPrinter.addTest(printer, suite, test);
            }
        } else {
            for (int i = 0; i < tests.length; ++i) {
                SigarTestPrinter.addTest(printer, suite, tests[i]);
            }
        }
        TestRunner runner = new TestRunner(printer);
        runner.doRun(suite);
    }

    static {
        LOG_PROPS = new String[][]{{"log4j.rootLogger", "DEBUG, R"}, {"log4j.appender.R", "org.apache.log4j.ConsoleAppender"}, {"log4j.appender.R.layout", "org.apache.log4j.PatternLayout"}, {"log4j.appender.R.layout.ConversionPattern", "%d [%t] %-5p %c - %m%n"}};
    }
}

