/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import org.hyperic.sigar.DirStat;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.test.SigarTestCase;

public class TestFileInfo
extends SigarTestCase {
    public TestFileInfo(String name) {
        super(name);
    }

    private void getFileInfo(Sigar sigar, String file) throws SigarException {
        this.traceln("Entry=" + file);
        FileInfo info = sigar.getFileInfo(file);
        this.assertGtEqZeroTrace("Permisions", info.getPermissions());
        this.assertTrueTrace("Permissions", info.getPermissionsString());
        this.assertGtEqZeroTrace("Mode", info.getMode());
        this.assertTrueTrace("Type", info.getTypeString());
        this.assertGtEqZeroTrace("Size", info.getSize());
        this.assertGtEqZeroTrace("Uid", info.getUid());
        this.assertGtEqZeroTrace("Gid", info.getUid());
        this.assertGtEqZeroTrace("Inode", info.getInode());
        this.traceln("Device=" + info.getDevice());
        this.assertGtEqZeroTrace("Nlink", info.getNlink());
        this.assertGtEqZeroTrace("Atime", info.getAtime());
        this.traceln(new Date(info.getAtime()).toString());
        this.assertGtZeroTrace("Mtime", info.getMtime());
        this.traceln(new Date(info.getMtime()).toString());
        this.assertGtZeroTrace("Ctime", info.getCtime());
        this.traceln(new Date(info.getCtime()).toString());
        if (info.getType() == 2) {
            try {
                DirStat stats = sigar.getDirStat(file);
                this.assertEqualsTrace("Total", new File(file).list().length, stats.getTotal());
                this.assertGtEqZeroTrace("Files", stats.getFiles());
                this.assertGtEqZeroTrace("Subdirs", stats.getSubdirs());
            }
            catch (SigarNotImplementedException e) {}
        } else {
            try {
                sigar.getDirStat(file);
                TestFileInfo.assertTrue(false);
            }
            catch (SigarException e) {
                TestFileInfo.assertTrue(true);
            }
        }
        sigar.getLinkInfo(file);
    }

    public void testCreate() throws Exception {
        String file;
        Sigar sigar = this.getSigar();
        File dir = new File(System.getProperty("user.dir"));
        String[] entries = dir.list();
        for (int i = 0; i < entries.length; ++i) {
            file = entries[i];
            File testFile = new File(dir, file);
            if (!testFile.exists() || !testFile.canRead() || testFile.isHidden()) continue;
            this.traceln(file + ":");
            this.getFileInfo(sigar, testFile.getAbsolutePath());
        }
        file = "NO SUCH FILE";
        try {
            this.getFileInfo(sigar, file);
            TestFileInfo.assertTrue(false);
        }
        catch (SigarNotImplementedException e) {
        }
        catch (SigarException e) {
            this.traceln(file + ": " + e.getMessage());
            TestFileInfo.assertTrue(true);
        }
        File tmp = File.createTempFile("sigar-", "");
        file = tmp.getAbsolutePath();
        tmp.deleteOnExit();
        this.traceln("TMP=" + file);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            FileInfo info = sigar.getFileInfo(file);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(file);
                os.write(1);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
            }
            tmp.setReadOnly();
            boolean changed = info.changed();
            this.traceln(info.diff());
            TestFileInfo.assertTrue(info.getPreviousInfo().getSize() != info.getSize());
            TestFileInfo.assertTrue(changed);
        }
        catch (SigarNotImplementedException e) {
        }
        catch (SigarException e) {
            throw e;
        }
    }
}

