/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.test.SigarTestCase;

public class TestProcState
extends SigarTestCase {
    public TestProcState(String name) {
        super(name);
    }

    private void traceState(Sigar sigar, long pid) {
        try {
            ProcState procState = sigar.getProcState(pid);
            this.traceln("[pid=" + pid + "] " + procState);
        }
        catch (SigarException e) {
            this.traceln("pid " + pid + ": " + e.getMessage());
        }
    }

    public void testCreate() throws Exception {
        Sigar sigar = this.getSigar();
        try {
            sigar.getProcState(this.getInvalidPid());
        }
        catch (SigarException e) {
            // empty catch block
        }
        ProcState procState = sigar.getProcState(sigar.getPid());
        this.traceState(sigar, sigar.getPid());
        char state = procState.getState();
        TestProcState.assertTrue(state == 'R' || state == 'S');
        TestProcState.assertTrue(procState.getName().indexOf("java") != -1);
        long[] pids = sigar.getProcList();
        for (int i = 0; i < pids.length; ++i) {
            this.traceState(sigar, pids[i]);
        }
    }
}

