/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.DomainParticipantFactory;
import java.lang.reflect.Method;

class OSPLShutdown
extends Thread {
    @Override
    public void run() {
        int n;
        Thread thread = this.lookupShutdownThread();
        if (thread != null && this.isThreadCallBackThread(thread)) {
            System.err.println("Detected deadlock; attempting to exit from within listener call-back. Fatal error: entities have not been deleted; restart of OpenSplice is required");
            Runtime.getRuntime().halt(2);
        }
        if ((n = DomainParticipantFactory.get_instance().delete_contained_entities()) != 0) {
            System.err.println("Error in DomainParticipantFactory.delete_contained_entities, status = " + n);
        }
    }

    private Thread lookupShutdownThread() {
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                if (!stackTraceElementArray[i].getMethodName().equals("exit") || !stackTraceElementArray[i].getClassName().equals("java.lang.Shutdown")) continue;
                return thread;
            }
        }
        return null;
    }

    private boolean isThreadCallBackThread(Thread thread) {
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            try {
                for (Class<?> clazz = Class.forName(stackTraceElementArray[i].getClassName()); clazz != null; clazz = clazz.getSuperclass()) {
                    for (Class<?> clazz2 : clazz.getInterfaces()) {
                        if (!clazz2.getName().startsWith("DDS.") || !clazz2.getName().contains("Listener")) continue;
                        for (Method method : clazz2.getMethods()) {
                            if (!method.getName().equals(stackTraceElementArray[i].getMethodName())) continue;
                            return true;
                        }
                    }
                }
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }
}

