/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.chat;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Scanner;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnection;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.Message;

public class SimpleClient
implements NodeConnectionListener {
    private static String gatewayIP = "127.0.0.1";
    private static int gatewayPort = 5500;
    private MrUdpNodeConnection connection;
    private InetSocketAddress address = new InetSocketAddress(gatewayIP, gatewayPort);
    private Shell shell;

    public static void main(String[] args) {
        new SimpleClient();
    }

    public SimpleClient() {
        try {
            this.connection = new MrUdpNodeConnection();
            this.connection.addNodeConnectionListener(this);
            this.connection.connect(this.address);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connected(NodeConnection remoteCon) {
        ApplicationMessage message = new ApplicationMessage();
        if (this.shell == null) {
            this.shell = new Shell(message, remoteCon);
            new Thread(this.shell).start();
        }
    }

    @Override
    public void newMessageReceived(NodeConnection remoteCon, Message message) {
        System.out.println(message.getContentObject());
    }

    @Override
    public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
        System.out.println("RECONNECTED");
    }

    @Override
    public void disconnected(NodeConnection remoteCon) {
        System.out.println("DISCONNECTED");
    }

    @Override
    public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
        System.out.println("UNSENT MESSAGES");
        for (Message m : unsentMessages) {
            System.out.println("MENSAGEM NAO ENVIADA: " + m);
        }
    }

    @Override
    public void internalException(NodeConnection remoteCon, Exception e) {
    }

    public class Shell
    implements Runnable {
        private NodeConnection nodeCon;

        public Shell(ApplicationMessage msg, NodeConnection conn) {
            this.nodeCon = conn;
        }

        @Override
        public void run() {
            try {
                String serializableContent = "";
                Scanner scan = new Scanner(System.in);
                while (scan.hasNext()) {
                    ApplicationMessage msg = new ApplicationMessage();
                    System.out.println("============================ START MSG ");
                    serializableContent = scan.nextLine();
                    if (serializableContent.compareToIgnoreCase("disconnect") == 0) {
                        System.out.println(">> INIT DISCONNECT");
                        this.nodeCon.disconnect();
                    } else if (serializableContent.compareToIgnoreCase("reconnect") == 0) {
                        System.out.println(">> INIT RECONNECT");
                        this.nodeCon.connect(SimpleClient.this.address);
                    } else if (serializableContent.compareToIgnoreCase("test") == 0) {
                        int i = 0;
                        while (i < 100) {
                            ApplicationMessage l = new ApplicationMessage();
                            l.setContentObject((Serializable)((Object)(String.valueOf(i) + " ")));
                            this.nodeCon.sendMessage(l);
                            ++i;
                        }
                    } else {
                        System.out.println(">> MSG:" + serializableContent);
                        msg.setContentObject((Serializable)((Object)serializableContent));
                        this.nodeCon.sendMessage(msg);
                    }
                    System.out.println("============================ FINISH MSG ");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

