/*
 * Decompiled with CFR 0.152.
 */
package net.rudp;

public class ReliableSocketProfile {
    public static final int MAX_SEND_QUEUE_SIZE = 32;
    public static final int MAX_RECV_QUEUE_SIZE = 64;
    public static final int MAX_SEGMENT_SIZE = 256;
    public static final int MAX_OUTSTANDING_SEGS = 3;
    public static final int MAX_RETRANS = 10;
    public static final int MAX_CUMULATIVE_ACKS = 3;
    public static final int MAX_OUT_OF_SEQUENCE = 3;
    public static final int MAX_AUTO_RESET = 10;
    public static final int NULL_SEGMENT_TIMEOUT = 30000;
    public static final int RETRANSMISSION_TIMEOUT = 1200;
    public static final int CUMULATIVE_ACK_TIMEOUT = 600;
    public static final int UDP_WRITE_SLEEP_TIME_MILLIS = 0;
    public static final int UDP_WRITE_SLEEP_TIME_NANOS = 0;
    private final int _maxSendQueueSize;
    private final int _maxRecvQueueSize;
    private final int _maxSegmentSize;
    private final int _maxOutstandingSegs;
    private final int _maxRetrans;
    private final int _maxCumulativeAcks;
    private final int _maxOutOfSequence;
    private final int _maxAutoReset;
    private final int _nullSegmentTimeout;
    private final int _retransmissionTimeout;
    private final int _cumulativeAckTimeout;
    private int _udpSleepMillis;
    private int _udpSleepNanos;

    public ReliableSocketProfile() {
        this(32, 64, 256, 3, 0, 3, 3, 10, 30000, 1200, 600);
    }

    public ReliableSocketProfile(int maxSendQueueSize, int maxRecvQueueSize, int maxSegmentSize, int maxOutstandingSegs, int maxRetrans, int maxCumulativeAcks, int maxOutOfSequence, int maxAutoReset, int nullSegmentTimeout, int retransmissionTimeout, int cumulativeAckTimeout) {
        this.checkValue("maxSendQueueSize", maxSendQueueSize, 1, 1024);
        this.checkValue("maxRecvQueueSize", maxRecvQueueSize, 1, 1024);
        this.checkValue("maxSegmentSize", maxSegmentSize, 22, 65535);
        this.checkValue("maxOutstandingSegs", maxOutstandingSegs, 1, 255);
        this.checkValue("maxRetrans", maxRetrans, 0, 255);
        this.checkValue("maxCumulativeAcks", maxCumulativeAcks, 0, 255);
        this.checkValue("maxOutOfSequence", maxOutOfSequence, 0, 255);
        this.checkValue("maxAutoReset", maxAutoReset, 0, 255);
        this.checkValue("nullSegmentTimeout", nullSegmentTimeout, 0, 65535);
        this.checkValue("retransmissionTimeout", retransmissionTimeout, 100, 65535);
        this.checkValue("cumulativeAckTimeout", cumulativeAckTimeout, 100, 65535);
        this._maxSendQueueSize = maxSendQueueSize;
        this._maxRecvQueueSize = maxRecvQueueSize;
        this._maxSegmentSize = maxSegmentSize;
        this._maxOutstandingSegs = maxOutstandingSegs;
        this._maxRetrans = maxRetrans;
        this._maxCumulativeAcks = maxCumulativeAcks;
        this._maxOutOfSequence = maxOutOfSequence;
        this._maxAutoReset = maxAutoReset;
        this._nullSegmentTimeout = nullSegmentTimeout;
        this._retransmissionTimeout = retransmissionTimeout;
        this._cumulativeAckTimeout = cumulativeAckTimeout;
    }

    public ReliableSocketProfile(int maxSendQueueSize, int maxRecvQueueSize, int maxSegmentSize, int maxOutstandingSegs, int maxRetrans, int maxCumulativeAcks, int maxOutOfSequence, int maxAutoReset, int nullSegmentTimeout, int retransmissionTimeout, int cumulativeAckTimeout, int udpSleepMillis, int udpSleepNanos) {
        this(maxSendQueueSize, maxRecvQueueSize, maxSegmentSize, maxOutstandingSegs, maxRetrans, maxCumulativeAcks, maxOutOfSequence, maxAutoReset, nullSegmentTimeout, retransmissionTimeout, cumulativeAckTimeout);
        this._udpSleepMillis = udpSleepMillis;
        this._udpSleepNanos = udpSleepNanos;
    }

    public int maxSendQueueSize() {
        return this._maxSendQueueSize;
    }

    public int maxRecvQueueSize() {
        return this._maxRecvQueueSize;
    }

    public int maxSegmentSize() {
        return this._maxSegmentSize;
    }

    public int maxOutstandingSegs() {
        return this._maxOutstandingSegs;
    }

    public int maxRetrans() {
        return this._maxRetrans;
    }

    public int maxCumulativeAcks() {
        return this._maxCumulativeAcks;
    }

    public int maxOutOfSequence() {
        return this._maxOutOfSequence;
    }

    public int maxAutoReset() {
        return this._maxAutoReset;
    }

    public int nullSegmentTimeout() {
        return this._nullSegmentTimeout;
    }

    public int retransmissionTimeout() {
        return this._retransmissionTimeout;
    }

    public int cumulativeAckTimeout() {
        return this._cumulativeAckTimeout;
    }

    public int udpSleepMillis() {
        return this._udpSleepMillis;
    }

    public int udpSleepNanos() {
        return this._udpSleepNanos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this._maxSendQueueSize).append(", ");
        sb.append(this._maxRecvQueueSize).append(", ");
        sb.append(this._maxSegmentSize).append(", ");
        sb.append(this._maxOutstandingSegs).append(", ");
        sb.append(this._maxRetrans).append(", ");
        sb.append(this._maxCumulativeAcks).append(", ");
        sb.append(this._maxOutOfSequence).append(", ");
        sb.append(this._maxAutoReset).append(", ");
        sb.append(this._nullSegmentTimeout).append(", ");
        sb.append(this._retransmissionTimeout).append(", ");
        sb.append(this._cumulativeAckTimeout).append(", ");
        sb.append(this._udpSleepMillis).append(", ");
        sb.append(this._udpSleepNanos);
        sb.append("]");
        return sb.toString();
    }

    private void checkValue(String param, int value, int minValue, int maxValue) {
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException(param);
        }
    }
}

