#ifdef DDS_IDL
#define DDS_KEY __dds_key
#else
#define DDS_KEY
#endif

#include <SystemTopics.ddl>

//Generic SDDL topic for node information exchange
struct Message
{
	DDS_KEY long long lspSenserId; //Least Significant Part of Sender ID
	DDS_KEY long long mspSenderId; //Most Significant Part of Sender ID
	long long lspSenderGatewayId; //Least Significant Part of Sender Gateway ID
	long long mspSenderGatewayId; //Most Significant Part of Sender Gateway ID
	long long lspRecipientId; //Least Significant Part of Recipient ID
	long long mspRecipientId; //Most Significant Part of Recipient ID
	long long lspRecipientGatewayId; //Least Significant Part of Recipient Gateway ID
	long long mspRecipientGatewayId; //Most Significant Part of Recipient Gateway ID
	sequence<string> stamps;
	sequence<octet> content;
	sequence<GroupTopic> groupCollection;
	long localLogicalTime; //Lamport's logical time
};