#include "SystemTopics.ddl"

module SddlOpenSpliceTopics {

	//Generic SDDL topic for node information exchange
	struct Message
	{
		long long lspSenserId; //Least Significant Part of Sender ID
		long long mspSenderId; //Most Significant Part of Sender ID
		long long lspSenderGatewayId; //Least Significant Part of Sender Gateway ID
		long long mspSenderGatewayId; //Most Significant Part of Sender Gateway ID
		long long lspRecipientId; //Least Significant Part of Recipient ID
		long long mspRecipientId; //Most Significant Part of Recipient ID
		long long lspRecipientGatewayId; //Least Significant Part of Recipient Gateway ID
		long long mspRecipientGatewayId; //Most Significant Part of Recipient Gateway ID
		sequence<string> stamps;
		sequence<octet> content;
		sequence<GroupTopic> groupCollection;
		long localLogicalTime; //Lamport's logical time
	};
	#pragma keylist Message lspSenserId mspSenderId

};