module SddlOpenSpliceTopics {

	//Estrutura utilizada pelo GW para enviar os grupos para o domnio
	struct GroupTopic
	{
		long groupType;
		sequence<long> groupIDCollection;
	};

	struct GroupAdvertisementTopic
	{
		long long leastSignificantBitsGatewayId;
		long long mostSignificantBitsGatewayId;
		long long leastSignificantBitsVehicleId;
		long long mostSignificantBitsVehicleId;
		long groupType;
		sequence<long> groupOperationCollection;
	};
	#pragma keylist GroupAdvertisementTopic leastSignificantBitsVehicleId mostSignificantBitsVehicleId

	struct PrivateMessageTopic
	{
		long long leastSignificantBitsVehicleId;
		long long mostSignificantBitsVehicleId;
		long long leastSignificantBitsGatewayId;
		long long mostSignificantBitsGatewayId;
		long groupId;
		long groupType;
		sequence<octet> message;
		//boolean toOutsideDomain; //Pode usar este tpico para enviar mensagens para os veculos e Domnio
		long messageId;
	};
	#pragma keylist PrivateMessageTopic messageId
	
	struct GroupReportTopic
	{
		long messageId;
		long groupId;
		long groupType;
		long numberOfNodes;
	};
	#pragma keylist GroupReportTopic messageId

	//Utilizado como nested-structure no tpico UnsentMessageTopic
	struct MessageStructureTopic
	{
		sequence<octet> message;
	};

	struct UnsentMessageTopic
	{
		long long leastSignificantBitsVehicleId;
		long long mostSignificantBitsVehicleId;
		long long leastSignificantBitsGatewayId;
		long long mostSignificantBitsGatewayId;
		sequence<MessageStructureTopic> unsentMessages;
	};
	#pragma keylist UnsentMessageTopic leastSignificantBitsVehicleId mostSignificantBitsVehicleId

	struct PingTopic
	{
		octet pingId;
		long long leastSignificantBitsGatewayId;
		long long mostSignificantBitsGatewayId;
		long long leastSignificantBitsVehicleId;
		long long mostSignificantBitsVehicleId;
		long long timestamp; //ou outro tipo de tempo. Necessrio?
		boolean pingCore; //Informar se eh um pingCore
		boolean ping; //Assim  possvel usar o mesmo tempo para receber e enviar dados. Informa se  PING ou PONG
		long groupType;
		long groupId;
	};
	#pragma keylist PingTopic pingId

	struct LoadReportTopic
	{
		long long leastSignificantBitsParticipantId;
		long long mostSignificantBitsParticipantId;
		octet participantType; //GW, GroupDefiner, Monitor,... Podemos monitorar todos os elementos no domnio e saber seu tipo
		octet cpuUsage;
		long freeMemory;
		long numberOfConnectedVehicles;
		string participantIp; //til no caso do GW onde o PoM-Manager precisa saber o IP de cada GW para gerar a lista
	};
	#pragma keylist LoadReportTopic leastSignificantBitsParticipantId mostSignificantBitsParticipantId
	

	struct ConnectionReportTopic
	{
		long long leastSignificantBitsVehicleId;
		long long mostSignificantBitsVehicleId;
		long long leastSignificantBitsGatewayId;
		long long mostSignificantBitsGatewayId;
		boolean connected;
	};
	#pragma keylist ConnectionReportTopic leastSignificantBitsVehicleId mostSignificantBitsVehicleId

	struct GroupMessageTopic
	{
		long long leastSignificantBitsGatewayId;
		long long mostSignificantBitsGatewayId;
		long long localLogicalTime;
		sequence<octet> message;
	};
	#pragma keylist GroupMessageTopic leastSignificantBitsGatewayId mostSignificantBitsGatewayId
	
	struct PointTopic
	{
		double latitude;
		double longitude;
	};
	
	struct GroupRegionTopic
	{
		string groupName;
		long groupType;
		long groupId;
		sequence<PointTopic> polygon;
	};
	#pragma keylist GroupRegionTopic groupType groupId
	
	struct GroupInfoStructure
	{
		long groupType;
		long groupId;
		sequence<string> mobileNodesIds;
	};

	struct AllGroupsInfoTopic
	{
		long requestId;
		sequence<GroupInfoStructure> groups;
	};
	#pragma keylist AllGroupsInfoTopic requestId
	
	struct AllGroupsInfoRequestTopic
	{
		long requestId;
	};
	#pragma keylist AllGroupsInfoRequestTopic requestId

};